<?php
/*
 * ChallengeController
 *
 * Endpoints para desafios.  Permite listar os desafios do dia para um
 * usuário e submeter respostas aos desafios.  Requer autenticação.
 */

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

require_once __DIR__ . '/ChallengeService.php';
require_once __DIR__ . '/TokenService.php';

try {
    $service = new ChallengeService();
} catch (Throwable $e) {
    error_log('[ChallengeController] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}

try {
    $method = $_SERVER['REQUEST_METHOD'];
    $userId = require_token();
    if ($method === 'GET') {
        $date = $_GET['date'] ?? date('Y-m-d');
        $challenges = $service->getDailyChallenges($userId, $date);
        echo json_encode(['success' => true, 'challenges' => $challenges], JSON_UNESCAPED_UNICODE);
        exit;
    } elseif ($method === 'POST') {
        $data = [];
        if (isset($_POST['challenge_id'])) {
            $data['challenge_id'] = $_POST['challenge_id'];
            if (isset($_POST['response_text'])) $data['response_text'] = $_POST['response_text'];
        } else {
            $raw = file_get_contents('php://input');
            $json = json_decode($raw, true);
            if (is_array($json)) {
                $data = $json;
            }
        }
        $challengeId = isset($data['challenge_id']) ? (int)$data['challenge_id'] : 0;
        if ($challengeId <= 0) {
            http_response_code(422);
            echo json_encode(['success' => false, 'error' => 'challenge_id é obrigatório']);
            exit;
        }
        $result = $service->submitChallenge($userId, $challengeId, $data, $_FILES);
        echo json_encode($result, JSON_UNESCAPED_UNICODE);
        exit;
    } else {
        http_response_code(405);
        echo json_encode(['success' => false, 'error' => 'Método não suportado']);
        exit;
    }
} catch (Throwable $t) {
    error_log('[ChallengeController] ' . $t->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}