<?php
/*
 * Arquivo helper para conexões com o banco de dados.
 *
 * Esta função encapsula a criação de uma instância de PDO a partir
 * da classe Database definida em config.php.  Todas as services
 * utilizam get_db_connection() para obter um handle de banco de dados.
 */

require_once __DIR__ . '/../config.php';

/**
 * Retorna uma conexão PDO para o banco de dados configurado.  A
 * instância é criada a cada chamada; você pode adicionar caching
 * simples aqui se desejar reutilizar a conexão.
 *
 * @return PDO
 */
function get_db_connection(): PDO
{
    $database = new Database();
    return $database->pdo;
}