<?php
/*
 * RewardController
 *
 * Gerencia as rotas de recompensas.  Exige autenticação por token
 * para listagem e resgate.  As ações suportadas são:
 *   - GET  (action=list|my)   : lista recompensas disponíveis ou resgatadas
 *   - POST (action=redeem)    : resgata uma recompensa
 */

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

require_once __DIR__ . '/RewardService.php';
require_once __DIR__ . '/TokenService.php';

try {
    $service = new RewardService();
} catch (Throwable $e) {
    error_log('[RewardController] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];
$raw    = file_get_contents('php://input');
$data   = json_decode($raw, true);
if (!is_array($data)) {
    $data = $_POST ?: [];
}

try {
    if ($method === 'GET') {
        $userId = require_token();
        $action = $_GET['action'] ?? 'list';
        switch ($action) {
            case 'list':
                $res = $service->listRewards();
                echo json_encode($res, JSON_UNESCAPED_UNICODE);
                exit;
            case 'my':
                $res = $service->listUserRewards($userId);
                echo json_encode($res, JSON_UNESCAPED_UNICODE);
                exit;
            default:
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Ação inválida']);
                exit;
        }
    } elseif ($method === 'POST') {
        $action = $_GET['action'] ?? $data['action'] ?? null;
        switch ($action) {
            case 'redeem':
                $userId = require_token();
                $rewardId = isset($data['reward_id']) ? (int)$data['reward_id'] : 0;
                $res = $service->redeemReward($userId, $rewardId);
                echo json_encode($res, JSON_UNESCAPED_UNICODE);
                exit;
            default:
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Ação inválida']);
                exit;
        }
    }
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Método não suportado']);
    exit;
} catch (Throwable $e) {
    error_log('[RewardController] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}