<?php

require_once __DIR__ . '/Database.php';

/**
 * TrailService encapsula consultas e operações relacionadas às trilhas.
 */
class TrailService
{
    /** @var PDO */
    private $conn;

    public function __construct()
    {
        $this->conn = get_db_connection();
    }

    /**
     * Retorna todas as trilhas de uma inteligência.  Ordena por
     * week_number para manter a sequência.
     *
     * @param int $intelligenceId
     * @return array
     */
    public function getTrailsByIntelligence(int $intelligenceId): array
    {
        $stmt = $this->conn->prepare('SELECT id, week_number, title, description, available_from, available_to FROM trails WHERE intelligence_id = ? ORDER BY week_number ASC');
        $stmt->execute([$intelligenceId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Obtém uma única trilha pelo id.
     *
     * @param int $trailId
     * @return array|null
     */
    public function getTrail(int $trailId): ?array
    {
        $stmt = $this->conn->prepare('SELECT id, intelligence_id, week_number, title, description, available_from, available_to FROM trails WHERE id = ? LIMIT 1');
        $stmt->execute([$trailId]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        return $row ?: null;
    }
}