<?php
/*
 * IntelligenceController
 *
 * Endpoint GET para listar as inteligências trabalhadas.  Exige
 * autenticação por token e retorna a lista completa de
 * inteligências.  Pode ser extendido para filtrar por idioma se
 * necessário.
 */

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

require_once __DIR__ . '/IntelligenceService.php';
require_once __DIR__ . '/TokenService.php';

try {
    $service = new IntelligenceService();
} catch (Throwable $e) {
    error_log('[IntelligenceController] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Método não suportado']);
    exit;
}

try {
    // Autentica usuário; necessário para acessar conteúdos
    $uid = require_token();
    // Recupera lista de inteligências
    $list = $service->getIntelligences();
    echo json_encode(['success' => true, 'intelligences' => $list], JSON_UNESCAPED_UNICODE);
    exit;
} catch (Throwable $t) {
    error_log('[IntelligenceController] ' . $t->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}