<?php

require_once __DIR__ . '/Database.php';

/**
 * IntelligenceService consulta as inteligências disponíveis no sistema.
 */
class IntelligenceService
{
    /** @var PDO */
    private $conn;

    public function __construct()
    {
        $this->conn = get_db_connection();
    }

    /**
     * Retorna todas as inteligências com nomes em seus três idiomas e
     * descrição.  Ordena por id ascendente.
     *
     * @return array
     */
    public function getIntelligences(): array
    {
        $stmt = $this->conn->prepare('SELECT id, name_pt, name_es, name_en, description FROM intelligences ORDER BY id ASC');
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}