<?php
/*
 * ProgressController
 *
 * Endpoints para consultar o progresso do usuário por inteligência
 * e o mapa de jornada (classificação seed/muda/árvore).  Todos os
 * endpoints exigem autenticação via token.
 */

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

require_once __DIR__ . '/ProgressService.php';
require_once __DIR__ . '/TokenService.php';

try {
    $service = new ProgressService();
} catch (Throwable $e) {
    error_log('[ProgressController] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? 'intelligences';

try {
    if ($method === 'GET') {
        $userId = require_token();
        switch ($action) {
            case 'intelligences':
                $res = $service->getIntelligenceProgress($userId);
                echo json_encode($res, JSON_UNESCAPED_UNICODE);
                exit;
            case 'journey':
                $res = $service->getJourneyMap($userId);
                echo json_encode($res, JSON_UNESCAPED_UNICODE);
                exit;
            default:
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Ação inválida']);
                exit;
        }
    }
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Método não suportado']);
    exit;
} catch (Throwable $e) {
    error_log('[ProgressController] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}