<?php
/*
 * RankingController
 *
 * Expõe endpoint GET para recuperar ranking.  O parâmetro
 * `scope` determina o contexto: 'geral', 'escola' ou 'familia'.  O
 * ranking é calculado somando pontos de diferentes fontes (dias,
 * quizzes, desafios) e ordenando em ordem decrescente.
 */

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

require_once __DIR__ . '/RankingService.php';
require_once __DIR__ . '/TokenService.php';

try {
    $service = new RankingService();
} catch (Throwable $e) {
    error_log('[RankingController] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        http_response_code(405);
        echo json_encode(['success' => false, 'error' => 'Método não suportado']);
        exit;
    }
    $userId = require_token();
    $scope = $_GET['scope'] ?? 'geral';
    $ranking = $service->getRanking($userId, $scope);
    echo json_encode(['success' => true, 'ranking' => $ranking], JSON_UNESCAPED_UNICODE);
    exit;
} catch (Throwable $t) {
    error_log('[RankingController] ' . $t->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}