<?php
/*
 * TestimonialController
 *
 * Endpoint para depoimentos.  Permite listar depoimentos aprovados
 * (GET) e criar um novo depoimento (POST).  Requer token para
 * envio, mas a listagem é pública.
 */

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

require_once __DIR__ . '/TestimonialService.php';
require_once __DIR__ . '/TokenService.php';

try {
    $service = new TestimonialService();
} catch (Throwable $e) {
    error_log('[TestimonialController] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}

try {
    $method = $_SERVER['REQUEST_METHOD'];
    if ($method === 'GET') {
        $list = $service->getTestimonials();
        echo json_encode(['success' => true, 'testimonials' => $list], JSON_UNESCAPED_UNICODE);
        exit;
    } elseif ($method === 'POST') {
        $userId = require_token();
        $raw = file_get_contents('php://input');
        $data = json_decode($raw, true);
        if (!is_array($data)) {
            $data = $_POST ?: [];
        }
        $rating = isset($data['rating']) ? (int)$data['rating'] : 0;
        $comment = trim($data['comment'] ?? '');
        if ($rating < 1 || $rating > 5 || $comment === '') {
            http_response_code(422);
            echo json_encode(['success' => false, 'error' => 'Nota e comentário são obrigatórios']);
            exit;
        }
        $ok = $service->createTestimonial($userId, $rating, $comment);
        if ($ok) {
            echo json_encode(['success' => true]);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'error' => 'Não foi possível salvar']);
        }
        exit;
    } else {
        http_response_code(405);
        echo json_encode(['success' => false, 'error' => 'Método não suportado']);
        exit;
    }
} catch (Throwable $t) {
    error_log('[TestimonialController] ' . $t->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}