<?php

require_once __DIR__ . '/Database.php';

/**
 * TestimonialService lida com depoimentos enviados pelos usuários.
 */
class TestimonialService
{
    /** @var PDO */
    private $conn;

    public function __construct()
    {
        $this->conn = get_db_connection();
    }

    /**
     * Lista depoimentos aprovados.  Retorna nota, comentário, data e
     * nome do usuário (opcional).
     *
     * @return array
     */
    public function getTestimonials(): array
    {
        $stmt = $this->conn->prepare('SELECT t.id, t.rating, t.comment, t.created_at, u.name AS user_name FROM testimonials t JOIN users u ON t.user_id = u.id WHERE t.approved = 1 ORDER BY t.created_at DESC');
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Cria um novo depoimento.  Define aprovado=0 para moderação.
     *
     * @param int $userId
     * @param int $rating
     * @param string $comment
     * @return bool
     */
    public function createTestimonial(int $userId, int $rating, string $comment): bool
    {
        if ($rating < 1 || $rating > 5) {
            return false;
        }
        $stmt = $this->conn->prepare('INSERT INTO testimonials (user_id, rating, comment, created_at, approved) VALUES (?,?,?,?,0)');
        return $stmt->execute([$userId, $rating, $comment, date('Y-m-d H:i:s')]);
    }
}