<?php
/*
 * TrailController
 *
 * Endpoints para recuperação de trilhas.  Permite listar trilhas
 * por inteligência via `intelligence_id` ou recuperar uma trilha
 * específica via `id` em requisições GET.  Exige token válido.
 */

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

require_once __DIR__ . '/TrailService.php';
require_once __DIR__ . '/TokenService.php';

try {
    $service = new TrailService();
} catch (Throwable $e) {
    error_log('[TrailController] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Método não suportado']);
    exit;
}

try {
    $uid = require_token();
    $id   = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    $intelligenceId = isset($_GET['intelligence_id']) ? (int)$_GET['intelligence_id'] : 0;
    if ($intelligenceId > 0) {
        $trails = $service->getTrailsByIntelligence($intelligenceId);
        echo json_encode(['success' => true, 'trails' => $trails], JSON_UNESCAPED_UNICODE);
        exit;
    }
    if ($id > 0) {
        $trail = $service->getTrail($id);
        if (!$trail) {
            http_response_code(404);
            echo json_encode(['success' => false, 'error' => 'Trilha não encontrada'], JSON_UNESCAPED_UNICODE);
            exit;
        }
        echo json_encode(['success' => true, 'trail' => $trail], JSON_UNESCAPED_UNICODE);
        exit;
    }
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Parâmetro inválido']);
    exit;
} catch (Throwable $t) {
    error_log('[TrailController] ' . $t->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Erro interno']);
    exit;
}