<?php
/**
 * Configuração de conexão com a base de dados e helpers para sessão.
 *
 * Esta configuração segue o padrão visto no exemplo fornecido: uma
 * classe Database que expõe uma instância de PDO. Ajuste os valores
 * de host, banco, usuário e senha conforme o ambiente em que o
 * backend for implantado.  Use UTC como timezone padrão para evitar
 * problemas de fuso horário.
 */

class Database
{
    /** @var string */
    private $host = 'localhost';
    /** @var string */
    private $db   = 'desafio_inteligencias';
    /** @var string */
    private $user = 'root';
    /** @var string */
    private $pass = '';
    /** @var string */
    private $charset = 'utf8mb4';

    /** @var PDO */
    public $pdo;

    public function __construct()
    {
        $dsn = "mysql:host={$this->host};dbname={$this->db};charset={$this->charset}";
        try {
            $this->pdo = new PDO($dsn, $this->user, $this->pass);
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            // Em produção, capture este erro e exiba uma mensagem amigável
            die('Falha ao conectar ao banco de dados: ' . $e->getMessage());
        }
    }
}

/**
 * Retorna se o usuário está logado na sessão web.  Esta função não
 * é utilizada nos endpoints de API (que usam autenticação por token),
 * mas pode ser útil para o painel administrativo baseado em páginas
 * PHP.
 */
function is_logged_in(): bool
{
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    return isset($_SESSION['user_id']);
}

/**
 * Exige que o usuário esteja logado.  Caso contrário redireciona
 * para a página de login.
 */
function require_login(): void
{
    if (!is_logged_in()) {
        header('Location: /login.php');
        exit;
    }
}